print(Unquoted, "dynwerkzeug.m");
print(Unquoted, "Hilfsmittel zur Untersuchung Dynamischer Systeme");
print(Unquoted, "================================================");


l2v:=X->matrix( nops(X),1, X):
print(Unquoted, "l2v(X) ist der Vektor zu der Liste X.");
print(Unquoted, "========================================================");

print(Unquoted, "========================================================");
print(Unquoted, "===========  KONTINUIERLICHE SYSTEME  ==================");
print(Unquoted, "========================================================");
print(Unquoted, "========================================================");
print(Unquoted, "===========  Dimension 1 ===============================");
print(Unquoted, "========================================================");


strich:=proc(t1,x1,m,L)
  local l,P1,P2;
begin;
l:=float(2*sqrt(1+m^2));
P1:=[t1-L/l,x1-m*L/l];
P2:=[t1+L/l,x1+m*L/l];
return( plot::Line2d( P1,P2 ) );
end_proc:

rifeld:=proc(A,B,f,nt,nx,L)
  local dt,dx,jt,jx;
  begin;
dt:=(B[1]-A[1])/nt;
dx:=(B[2]-A[2])/nx;
return(strich(A[1]+jt*dt,A[2]+jx*dx,f(A[2]+jx*dx),L)  $jt=0..nt $jx=0..nx );
end_proc:
print(Unquoted, "Prozedur rifeld(A,B,f,nt,nx,L)");
print(Unquoted, "A ist der linke untere und B ist der rechte obere Eckpunkt");
print(Unquoted, "des Rechtecks im tx-System, das betrachtet wird.");
print(Unquoted, "f ist die rechte Seite der Differentialgleichung dx/dt=f(x).");
print(Unquoted, "Die Parameter nt und nx definieren die Maschen des Gitters.");
print(Unquoted, "Ausgegeben wird ein plotfaehiges Objekt mit Linienelementen");
print(Unquoted, "der Differentialgleichung.");
print(Unquoted, "L legt die Laenge der Strecken fest.");
print(Unquoted, "Gleiche Laenge der Striche nur bei Scaling=Constrained.");
print(Unquoted, "==========================================");

euler1:=proc(x0,f,n,dt)
  local k, X;
begin;
X[0]:=x0;
for k from 1 to n do
	X[k]:=float(X[k-1]+f(X[k-1])*dt);
end_for;
delete k;
return( plot::Polygon2d([ [k*dt, X[k]] $ k=0..n ], AxesTitles=["t","x"]) );
 end_proc:
print(Unquoted, "Prozedur euler1(x0,f,n,dt)");
print(Unquoted, "Zum Anfangswertproblem dx/dt=f(x), x(0)=x0, wird nach");
print(Unquoted, "dem eulerschen Polygonzugverfahren ein");
print(Unquoted, "plotfaehiges Objekt erstellt: ein Graph einer");
print(Unquoted, "Naeherungsloesung mit n Schritten der Schrittweite dt.");
print(Unquoted, "==========================================");

veuler1:=proc(x0,f,n,dt)
  local k, X, Q;
begin;
X[0]:=x0;
for k from 1 to n do
        Q:=X[k-1]+f(X[k-1])*dt/2;
	X[k]:=X[k-1]+f(Q)*dt;
end_for;
delete k;
return( plot::Polygon2d([ [k*dt, X[k]] $ k=0..n ], AxesTitles=["t","x"]) );
 end_proc:

print(Unquoted, "Prozedur veuler1(x0,f,n,dt)");
print(Unquoted, "Zum Anfangswertproblem dx/dt=f(x), x(0)=x0, wird nach");
print(Unquoted, "dem verbesserten eulerschen Polygonzugverfahren");
print(Unquoted, "ein plotfaehiges Objekt erstellt:");
print(Unquoted, "ein Graph einer");
print(Unquoted, "Naeherungsloesung mit n Schritten der Schrittweite dt.");
print(Unquoted, "==========================================");

RK:=proc(x0,f,n,dt)
  local j, X, k1, k2, k3, k4;
begin;
X[0]:=float(x0);
for j from 1 to n do
      k1:=f(X[j-1]);
      k2:=f( X[j-1]+k1*dt/2 );
      k3:=f( X[j-1]+k2*dt/2 );
      k4:=f( X[j-1]+k3*dt );
X[j]:=float(X[j-1]+(k1+2*k2+2*k3+k4)*dt/6);
end_for;
delete j;
return( [ X[j] $ j=0..n ] );
end_proc:

print(Unquoted, "Prozedur RK(x0,f,n,dt)" );
print(Unquoted, "Klassisches Runge-Kutta-Verfahren zur Erstellung");
print(Unquoted, "einer Wertetabelle einer Naeherungsloesung zur");
print(Unquoted, "Anfangswertaufgabe dx/dt=f(x), x(0)=x0 .");
print(Unquoted, "Ausgefuehrt werden n Schritte der Schrittweite dt.");
print(Unquoted, "==========================================");

bildRK1:=proc(x0,f,n,dt)
  local xliste, k;
begin;
xliste:=RK(x0,f,n,dt);
return( plot::Polygon2d( [ [(k-1)*dt,xliste[k]] $ k=1..n+1 ] ) );
end_proc:

print(Unquoted, "Prozedur bildRK1(x0,f,n,dt)");
print(Unquoted, "Zum Anfangswertproblem dx/dt=f(x), x(0)=x0, wird nach");
print(Unquoted, "dem klassischen Runge-Kutta-Verfahren");
print(Unquoted, "ein Objekt vom Typ Polygon2d einer Naeherungsloesung");
print(Unquoted, "mit n Schritten der Schrittweite dt erstellt.");
print(Unquoted, "==========================================================");

RKt:=proc(x0,F,n,t0,dt)
  local j, X, k1, k2, k3, k4;
begin;
X[0]:=x0;
for j from 1 to n do
      k1:=F(X[j-1], t0+(j-1)*dt);
      k2:=F( X[j-1]+k1*dt/2, t0+(j-1/2)*dt );
      k3:=F( X[j-1]+k2*dt/2, t0+(j-1/2)*dt );
      k4:=F( X[j-1]+k3*dt, t0+j*dt );
X[j]:=float(X[j-1]+(k1+2*k2+2*k3+k4)*dt/6);
end_for;
delete j;
return( [ X[j] $ j=0..n ] );
end_proc:

print(Unquoted, "Prozedur RKt(x0,F,n,t0,dt)" );
print(Unquoted, "Klassisches Runge-Kutta-Verfahren zur Erstellung");
print(Unquoted, "einer Wertetabelle einer Naeherungsloesung zur");
print(Unquoted, "Anfangswertaufgabe dx/dt=F(x,t), x(0)=x0 .");
print(Unquoted, "Ausgefuehrt werden n Schritte der Schrittweite dt.");
print(Unquoted, "Startzeit ist t=t0.");
print(Unquoted, "==========================================");


print(Unquoted, "==========================================================");
print(Unquoted, "==================  Dimension 2  =========================");
print(Unquoted, "==========================================================");

euler2:=proc(X0,V,n,dt)
  local P,j;
begin;
P[0]:=X0;
for j from 1 to n do
	P[j]:=float(P[j-1]+dt*V( P[j-1] ));
end_for;
delete j;
return( plot::Polygon2d( [ P[j] $ j=0..n ], TicksNumber=Low ) );
 end_proc:

print(Unquoted, "Prozedur euler2(X0,V,n,dt)");
print(Unquoted, "Eulersches Polygonzugverfahren.");
print(Unquoted, "X0 ist der Startvektor,");
print(Unquoted, "V die Funktion X->V(X) auf der rechten Seite");
print(Unquoted, "der DGL (d/dt)X=V(X). Schrittzahl n, Schrittweite dt.");
print(Unquoted, "Ausgegeben wird plotfaehiges Objekt vom Typ Polygon2d.");
print(Unquoted, "==========================================");

print(Unquoted, "Prozedur RK(x0,f,n,dt)" );
print(Unquoted, "Klassisches Runge-Kutta-Verfahren zur Erstellung");
print(Unquoted, "einer Wertetabelle einer Naeherungsloesung zur");
print(Unquoted, "Anfangswertaufgabe dx/dt=f(x), x(0)=x0 .");
print(Unquoted, "Ausgefuehrt werden n Schritte der Schrittweite dt.");
print(Unquoted, "Geht auch in Dimension 2, x0 als Vektor definieren!");
print(Unquoted, "Ausgegeben wird eine Liste von Punkten.");
print(Unquoted, "==========================================");

veuler2:=proc(X0,V,n,dt)
  local P,j,Q;
begin;
P[0]:=X0;
for j from 1 to n do
	Q:=P[j-1]+dt/2*V( P[j-1] );
P[j]:=float(P[j-1]+dt*V( Q ));
end_for;
delete j;
return( plot::Polygon2d( [ P[j] $ j=0..n ], TicksNumber=Low ) );
 end_proc:

print(Unquoted, "Prozedur veuler2(X0,V,n,dt)");
print(Unquoted, "Verbessertes Eulersches Polygonzugverfahren.");
print(Unquoted, "X0 ist der Startvektor,");
print(Unquoted, "V die Funktion X->V(X) auf der rechten Seite");
print(Unquoted, "der DGL (d/dt)X=V(X). Schrittzahl n, Schrittweite dt.");
print(Unquoted, "Ausgegeben wird plotfaehiges Objekt vom Typ Polygon2d.");
print(Unquoted, "==========================================");

bildRK2:=proc(x0,f,n,dt)
  local xliste, k;
begin;
xliste:=RK(x0,f,n,dt);
return( plot::Polygon2d( [ xliste[k] $ k=1..n+1 ] ) );
end_proc:

print(Unquoted, "Prozedur bildRK2(x0,f,n,dt)");
print(Unquoted, "Zum Anfangswertproblem dx/dt=f(x), x(0)=x0, wird nach");
print(Unquoted, "dem klassischen Runge-Kutta-Verfahren");
print(Unquoted, "ein plotfaehiges Objekt erstellt:");
print(Unquoted, "ein Graph einer");
print(Unquoted, "Naeherungsloesung mit n Schritten der Schrittweite dt.");
print(Unquoted, "========================================================");

flusslinie:=proc(X0, F, n, dt)
  local xliste, k, linie, nm, pfeil;
begin;
  xliste:=RK(X0, F, n, dt);
  linie:=plot::Polygon2d([ xliste[k] $ k=1..n+1] );
  nm:=floor(n/2);
  pfeil:=plot::Arrow2d(xliste[nm], xliste[nm+1], TipStyle=Open);
  if dt<0 then
     pfeil:=plot::Arrow2d(xliste[nm], xliste[nm-1], TipStyle=Open);
  end_if;
  return( linie, pfeil );
end_proc:

print(Unquoted, "Prozedur flusslinie(x0,f,n,dt)");
print(Unquoted, "liefert wie bildRK2(x0,f,n,dt) den Graphen");
print(Unquoted, "einer Naeherungsloesung zum Anfangswertproblem");
print(Unquoted, "dx/dt=f(x), x(0)=x0 nach dem klassischen Runge-Kutta-Verf.");
print(Unquoted, "Zusaetzlich zeigt ein Pfeil die Flussrichtung an.");
print(Unquoted, "x0 als Vektor definieren (oder l2v([x01,x02]) )!");
print(Unquoted, "========================================================");

flussbild:=proc(SP, F, m, radius, n, dt)
  local bilder, k, AP, bildSP;
begin;
  for k from 1 to m do
	AP:=SP+radius*l2v(float([cos(k*2*PI/m), sin(k*2*PI/m)]));
        bilder[k]:=flusslinie(AP, F, n, dt);
  end_for;
  bildSP:=plot::Point2d( SP, PointStyle=XCrosses, TicksNumber=Low );
  return( bilder[k] $ k=1..m, bildSP );
end_proc:

print(Unquoted, "Prozedur flussbild(SP, F, m, radius, n, dt)");
print(Unquoted, "SP ist Ortsvektor eines singulaeren Punktes von dx/dt=F(x).");
print(Unquoted, "Auf dem Kreis um SP mit Radius radius werden");
print(Unquoted, "m aequidistant liegende Punkte gebildet und als Startpunkte");
print(Unquoted, "von Flusslinien verwandt - n Schritte, Schrittweite dt.");
print(Unquoted, "Ausgegeben wird ein plotfaehiges Objekt: die Flusslinien");
print(Unquoted, "und der Punkt zu SP.");
print(Unquoted, "Scaling=Constrained beim Plotten ist empfehlenswert.");
print(Unquoted, "========================================================");


pfeilfeld:=proc(A,B,f,nx,ny, streckfaktor)
  local dy,dx,jx,jy, pfeil;
  begin;
pfeil:=X->plot::Arrow2d( X, X+streckfaktor*f(X), TipStyle=Open,
			 TicksNumber=Low, TipLength=2*unit::mm );
dx:=(B[1]-A[1])/nx;
dy:=(B[2]-A[2])/ny;
return( pfeil(l2v([A[1]+jx*dx,A[2]+jy*dy]))  $jx=0..nx $jy=0..ny );
end_proc:
print(Unquoted, "Prozedur pfeilfeld(A, B, F, nx, ny, streckfaktor)");
print(Unquoted, "A=[a1,a2] ist linke untere und B=[b1,b2] ist rechte obere");
print(Unquoted, "Ecke eines Rechtecks mit achsenparallelen Seiten.");
print(Unquoted, "In jedem Punkt P des Gitters im Rechteck mit");
print(Unquoted, "(nx+1)*(ny+1) Gitterpunkten wird der Pfeil streckfaktor*F(P)");
print(Unquoted, "angetragen. Die Groesse streckfaktor muss geeignet gewaehlt");
print(Unquoted, "werden. Ausgegeben wird ein plot-faehiges Objekt.");
print(Unquoted, "========================================================");

ableitungsmatrix:=proc(F)
begin;
return(matrix(2,2,[ diff(F([x,y])[1],x), diff(F([x,y])[1],y), diff(F([x,y])[2],x),diff(F([x,y])[2],y)]));
end_proc:
print(Unquoted, "ableitungsmatrix(F) liefert die Jakobimatrix der Funktion F.");
print(Unquoted, "========================================================");
