export(stats):

print(Unquoted, "Das kannst du machen:");
print(Unquoted,"==========================================");
print(Unquoted, "1. Listen bearbeiten:");

L2relH:=proc(L, m: Type::PosInt)
  local Lsort, k3, k4, H, d, u, o;
begin;
Lsort:=sort(L);
u:=Lsort[1]; o:=Lsort[ nops(L) ];
d:=(o-u)/m;
H:=[ 0 $ k3=1..m ]; delete k3;
k3 := 1;
k4 := 1;
while k3<=m do
   while (k4<nops(L) and Lsort[k4]<=u+k3*d) do H[k3]:=H[k3]+1; k4:=k4+1;
   end_while;
   k3:=k3+1;
end_while:
H[m]:=H[m]+1;
delete k3;
return( [ H[k3]/nops(L) $ k3=1..m ], u+d/2, d );
end_proc:
print(Unquoted, "Die Zahlen einer Liste L in m Klassen einteilen und");
print(Unquoted, "   die relativen Haeufigkeiten feststellen:");
print(Unquoted, "   L2relH(L,m) gibt:");
print(Unquoted, "   die Liste der relativen Haeufigkeiten,");
print(Unquoted, "   Mitte der ersten Klasse, Klassenbreite");
print(Unquoted, "---");

klotz:=(k,h,d)->plot::Polygon2d([[k-d/2,0],[k-d/2,h],[k+d/2,h],[k+d/2,0]]):

hist:=proc( pwerte, a, d)
local n1, k1, bilder;
begin 
   n1:=nops( pwerte );
   return( klotz(a+(k1-1)*d, pwerte[k1]/d, d) $ k1=1..n1 );
end_proc:

L2Hist:=(L,m) -> plot( hist( L2relH( L, m ) ), TicksNumber=Low ):
print(Unquoted, "Histogramm mit m Saeulen zur Liste L zeichnen: L2Hist(L,m)");
print(Unquoted, "das Gleiche mit Glockenkurve: L2pHist(L,m)"); 
print(Unquoted, "---");

phi:=x->1/sqrt(2*PI)*exp(-1/2*x^2):
  Phi:=x->float( int( phi(t), t=-infinity..x) ):
print(Unquoted, "phi ist die Gaussfunktion, Gphi die Glockenkurve,");
print(Unquoted, "Phi(x) ist das Integral ueber phi von -unendl bis x");
Gphi:=plot::Function2d( phi(x), x=-3..3, Color=RGB::Black):
L2pHist:=(L,m) -> plot( hist( L2relH( L, m ) ), Gphi ):
print(Unquoted, "---");


L2standL:=proc(L)
  local k4, mu, sigma;
begin;
mu:=stats::mean(L);
sigma:=stats::stdev(L);
return( [float(  (L[k4]-mu)/sigma ) $ k4=1..nops(L) ] );
end_proc:
print(Unquoted, "Liste L standardisieren: L2standL(L)");
print(Unquoted, "---");
print(Unquoted, "Mittelwert einer Liste L berechnen: mean(L)");
print(Unquoted, "---");
print(Unquoted, "Standardabweichung einer Liste L berechnen: stdev(L)");
print(Unquoted, "---");

print(Unquoted, "--------------------------");

print(Unquoted, "2. Listen erstellen:");
print(Unquoted, "---");

B:=proc(n : Type::PosInt , p , N : Type::PosInt )
  local j1;
begin;
return( [ binomialRandom(n,p)() $ j1=1..N ] );
end_proc:
print(Unquoted, "Liste von N Ergebnissen eines B(n,p)-verteilten X:");
print(Unquoted, "   B(n,p,N)");
print(Unquoted, "---");

BS:=proc(n : Type::PosInt , p, m : Type::PosInt )
  local j2, w;
begin;
w:=0;
for j2 from 1 to m do w:=w+binomialRandom(n,p)() end_for;
return( w )
end_proc:
print(Unquoted, "Summe von m B(n,p)-verteilten Werten: BS(n,p,m)" );
print(Unquoted, "---");

LBS:=proc(n : Type::PosInt, p, m : Type::PosInt, N : Type::PosInt)
  local j3;
begin;
return( [ BS(n,p,m) $ j3=1..N ] );
end_proc:
print(Unquoted, "Liste von N Summen je m B(n,p)-verteilter Werte:");
print(Unquoted, "   LBS(n,p,m,N)");
print(Unquoted, "---");

N01:=proc(n: Type::PosInt)
  local k0;
begin;
return( [ stats::normalRandom(0,1)() $ k=1..n ] );
end_proc:
print(Unquoted, "Liste von n N(0,1)-verteilten Werten erstellen: N01(n)");
print(Unquoted, "---");

S01:=proc(n: Type::PosInt)
  local k1, w;
begin;
w:=0;
for k1 from 1 to n do 
       w:=w+stats::normalRandom(0,1)();
end_for:
end_proc:
print(Unquoted, "Summe von n N(0,1)-verteilten Werten: S01(n)");
print(Unquoted, "---");

LS01:=proc(n: Type::PosInt, N: Type::PosInt)
  local k2;
begin;
return( [ S01(n) $ k2=1..N ] ):
end_proc:
print(Unquoted, "Liste von N Summen von je n N(0,1)-verteilten Zahlen: LS01(n,N) ");
print(Unquoted, "---");

cauchySum:=proc(n: Type::PosInt)
  local k4, cs;
begin;
cs:=0;
for k4 from 1 to n do cs:=cs+cauchyRandom(0,1)() end_for;
return( cs );
end_proc:

CS01:=proc(n: Type::PosInt, N : Type::PosInt)
  local k5;
begin;
return( [ cauchySum(n) $ k5=1..N ] )
end_proc:
print(Unquoted, "Liste von N Summen je n Cauchy(0,1)-verteilter Zahlen: CS01(n,N)" );
print(Unquoted, "---" );

print(Unquoted, "--------------------------");

print(Unquoted, "3. Brownsche Bewegung");
print(Unquoted, "---" );

xbrown:=proc( N : Type::PosInt )
  local k8, P0, Px, GP;
begin;
P0:=plot::Point2d( [0,0], Scaling=Constrained, Axes=None, TimeBegin=0, TimeEnd=15);
Px[0]:=0;
for k8 from 1 to N do Px[k8]:=Px[k8-1]+normalRandom(0,1)(); end_for;
delete k8;
GK:=plot::Point2d([ Px[k8], 0 ], PointStyle=Crosses, VisibleFromTo=k8*15/(N+1) .. (k8+1)*15/(N+1) ) $ k8=1..N;
return( plot( P0, GK ) );
end_proc:
print(Unquoted, "Eindimensionale Brownsche Bewegung mit N Spruengen:");
print(Unquoted, "    xbrown(N)");
print(Unquoted, "Hinweis: Animation durch Klicken auf das Bild starten.");
print(Unquoted, "---");

streubild:=proc(N : Type::PosInt)
  local Px, Py, k6, GP0, GPk, GP1;
begin;
GP0:=plot::Point2d([0,0], TimeBegin=0, TimeEnd=15, 
		   Scaling=Constrained, Axes=None);
Px[1]:=normalRandom(0,1)();
for k6 from 2 to N do Px[k6]:=normalRandom(0,1)() end_for;
delete k6;
Py[1]:=normalRandom(0,1)();
for k6 from 2 to N do Py[k6]:=normalRandom(0,1)() end_for;
delete k6;
for k6 from 1 to N do
	 GPk[k6]:=plot::Point2d( [ Px[k6], Py[k6] ],
	 PointStyle=Crosses, VisibleAfter=k6*15/N );
end_for;
delete k6; 
GP1:=  GPk[k6] $ k6=1..N;
return( plot( GP0, GP1 ) );
end_proc: 
print(Unquoted, "N Punkte der Ebene mit N(0,1)-verteilten Koordinaten erzeugen:");
print(Unquoted, "    streubild(N)" );
print(Unquoted, "Hinweis: Animation durch Klicken auf das Bild starten.");
print(Unquoted, "---");

trajekt:=proc( N : Type::PosInt )
  local k7, Px, Py, P0, GK;
begin;
P0:=plot::Point2d( [0,0], Scaling=Constrained, Axes=None, TimeBegin=0, TimeEnd=15);
Px[0]:=0;
for k7 from 1 to N do Px[k7]:=Px[k7-1]+normalRandom(0,1)(); end_for;
delete k7;
Py[0]:=0;
for k7 from 1 to N do Py[k7]:=Py[k7-1]+normalRandom(0,1)(); end_for;
delete k7;
GK:=plot::Line2d([ Px[k7-1], Py[k7-1] ], [ Px[k7], Py[k7] ], VisibleAfter=k7*15/N ) $ k7=1..N;
return( plot( P0, GK ) );
end_proc:
print(Unquoted, "Zweidimensionale Brownsche Bewegung mit N Kanten: trajekt(N)");
print(Unquoted, "Hinweis: Animation durch Klicken auf das Bild starten.");
print(Unquoted, "---");

print(Unquoted, "==========================================");

print(Unquoted, "Hinweis: Das Paket stats wurde automatisch geladen.");

Bnp:=proc( n : Type::PosInt, p )
  local k9;
begin;
return( [ binomialPF(n,p)(k9) $ k9=0..n ] )
end_proc:
print(Unquoted, "Tabelle der Wahrscheinlichkeiten eines B(n,p)-verteilten X: Bnp(n,p)");
print(Unquoted, "---");
